/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.large_boiler.capitalism;

import com.mangomilk.design_decor.blocks.large_boiler.capitalism.CapitalismBoilerStructure;
import com.mangomilk.design_decor.registry.CDDBlocks;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CapitalismLargeBoilerBlock
extends WrenchableDirectionalBlock {
    public static final BooleanProperty EXTENSION = BooleanProperty.m_61465_((String)"extension");
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final VoxelShape SHAPE = Block.m_49796_((double)-8.0, (double)-8.0, (double)-8.0, (double)24.0, (double)24.0, (double)24.0);

    public CapitalismLargeBoilerBlock(BlockBehaviour.Properties p_52591_) {
        super(p_52591_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)EXTENSION, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection != Direction.m_122387_((Direction.Axis)((Direction)pState.m_61143_((Property)f_52588_)).m_122434_(), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)) {
            return pState;
        }
        return (BlockState)pState.m_61124_((Property)EXTENSION, (Comparable)Boolean.valueOf(pNeighborState.m_60713_((Block)this)));
    }

    public Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        return ((Direction)super.m_5573_(context).m_61143_((Property)f_52588_)).m_122434_();
    }

    public VoxelShape m_7952_(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState p_54559_) {
        return RenderShape.MODEL;
    }

    public boolean m_7923_(BlockState p_54582_) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{EXTENSION}));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(itemInHand)) {
            return helper.getOffset(pPlayer, pLevel, pState, pPos, pHit).placeInWorld(pLevel, (BlockItem)itemInHand.m_41720_(), pPlayer, pHand, pHit);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        BlockPos pos = context.m_8083_();
        assert (stateForPlacement != null);
        Direction.Axis axis = ((Direction)stateForPlacement.m_61143_((Property)f_52588_)).m_122434_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState occupiedState;
                    BlockPos offset;
                    if (axis.m_7863_(x, y, z) != 0 || (offset = new BlockPos(x, y, z)).equals((Object)BlockPos.f_121853_) || (occupiedState = context.m_43725_().m_8055_(pos.m_121955_((Vec3i)offset))).m_247087_()) continue;
                    return null;
                }
            }
        }
        if (context.m_43725_().m_8055_(pos.m_121945_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE))).m_60713_((Block)this)) {
            stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)EXTENSION, (Comparable)Boolean.valueOf(true));
        }
        return stateForPlacement;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.m_183326_().m_183582_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        Direction.Axis axis = ((Direction)pState.m_61143_((Property)f_52588_)).m_122434_();
        for (Direction side : Iterate.directions) {
            if (side.m_122434_() == axis) continue;
            boolean[] blArray = Iterate.falseAndTrue;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                BlockState requiredStructure;
                Direction targetSide;
                boolean secondary;
                BlockPos structurePos = (secondary ? pPos.m_121945_(side) : pPos).m_121945_(targetSide = (secondary = blArray[i]) ? side.m_175362_(axis) : side);
                BlockState occupiedState = pLevel.m_8055_(structurePos);
                if (occupiedState == (requiredStructure = (BlockState)CDDBlocks.CAPITALISM_BOILER_STRUCTURAL.getDefaultState().m_61124_((Property)CapitalismBoilerStructure.f_52588_, (Comparable)targetSide.m_122424_()))) continue;
                if (!occupiedState.m_247087_()) {
                    pLevel.m_46961_(pPos, false);
                    return;
                }
                pLevel.m_46597_(structurePos, requiredStructure);
            }
        }
    }

    public static BlockState pickCorrectBoiler(BlockState stateForPlacement, Level level, BlockPos pos) {
        return stateForPlacement;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction> {
        private PlacementHelper() {
            super(state -> state.m_60734_() instanceof CapitalismLargeBoilerBlock, state -> ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_(), (Property)DirectionalBlock.f_52588_);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof CapitalismLargeBoilerBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof CapitalismLargeBoilerBlock || s.m_60734_() instanceof CapitalismLargeBoilerBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> CapitalismLargeBoilerBlock.pickCorrectBoiler(s, world, offset.getBlockPos())));
            }
            return offset;
        }
    }
}

